<?php

//use App\Http\Controllers\LocaleController;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Route;
use Livewire\Volt\Volt;
use Mpdf\Mpdf;

Route::get('/', function () {return view('welcome');})->name('home');





Route::get('set-language/{Lang}', [LocaleController::class, 'setLocale'])->name('set.language')->where('Lang', 'en|ar');
Route::get('/update-darkmode/{id}', [LocaleController::class, 'updateDarkMode'])->name('update.darkmode');


//exports
Route::get('/terms/print', function () {
    return view('exports.print.terms');
})->name('terms.print');


Route::get('/terms/pdf', function () {
    $mpdf = new Mpdf([
        'mode' => 'utf-8',
        'default_font' => 'amiri',
        'format' => 'A4',
        'orientation' => 'P',
        'margin_top' => 10,
        'margin_bottom' => 10,
        'margin_left' => 10,
        'margin_right' => 10,
    ]);

    // تحميل الـ Blade وعمل رندر ليه
    $html = view('exports.pdf.terms')->render();

    // توليد PDF من الـ HTML
    $mpdf->WriteHTML($html);

    // رجّع الملف للتحميل
    return response($mpdf->Output('orascom-terms.pdf', 'I'), 200)->header('Content-Type', 'application/pdf');

})->name('terms.download');



Route::middleware(['auth','two-factor'])->group(function () {
    Route::view('dashboard', 'dashboard')
        ->name('dashboard');
    Route::redirect('settings', 'settings/profile');

    Volt::route('settings/profile', 'settings.profile')->name('settings.profile');
    Volt::route('settings/password', 'settings.password')->name('settings.password');
    Volt::route('settings/appearance', 'settings.appearance')->name('settings.appearance');
    Volt::route('settings/two-factor', 'settings.two-factor')->name('settings.two-factor');
});

require __DIR__.'/auth.php';
